
/* !!! This is code generated by Prisma. Do not edit directly. !!!
/* eslint-disable */
// biome-ignore-all lint: generated file

Object.defineProperty(exports, "__esModule", { value: true });

const {
  PrismaClientKnownRequestError,
  PrismaClientUnknownRequestError,
  PrismaClientRustPanicError,
  PrismaClientInitializationError,
  PrismaClientValidationError,
  getPrismaClient,
  sqltag,
  empty,
  join,
  raw,
  skip,
  Decimal,
  Debug,
  DbNull,
  JsonNull,
  AnyNull,
  NullTypes,
  makeStrictEnum,
  Extensions,
  warnOnce,
  defineDmmfProperty,
  Public,
  getRuntime,
  createParam,
} = require('@prisma/client/runtime/client.js')


const Prisma = {}

exports.Prisma = Prisma
exports.$Enums = {}

/**
 * Prisma Client JS version: 7.2.0
 * Query Engine version: 0c8ef2ce45c83248ab3df073180d5eda9e8be7a3
 */
Prisma.prismaVersion = {
  client: "7.2.0",
  engine: "0c8ef2ce45c83248ab3df073180d5eda9e8be7a3"
}

Prisma.PrismaClientKnownRequestError = PrismaClientKnownRequestError;
Prisma.PrismaClientUnknownRequestError = PrismaClientUnknownRequestError
Prisma.PrismaClientRustPanicError = PrismaClientRustPanicError
Prisma.PrismaClientInitializationError = PrismaClientInitializationError
Prisma.PrismaClientValidationError = PrismaClientValidationError
Prisma.Decimal = Decimal

/**
 * Re-export of sql-template-tag
 */
Prisma.sql = sqltag
Prisma.empty = empty
Prisma.join = join
Prisma.raw = raw
Prisma.validator = Public.validator

/**
* Extensions
*/
Prisma.getExtensionContext = Extensions.getExtensionContext
Prisma.defineExtension = Extensions.defineExtension

/**
 * Shorthand utilities for JSON filtering
 */
Prisma.DbNull = DbNull
Prisma.JsonNull = JsonNull
Prisma.AnyNull = AnyNull

Prisma.NullTypes = NullTypes




  const path = require('path')

/**
 * Enums
 */
exports.Prisma.TransactionIsolationLevel = makeStrictEnum({
  ReadUncommitted: 'ReadUncommitted',
  ReadCommitted: 'ReadCommitted',
  RepeatableRead: 'RepeatableRead',
  Serializable: 'Serializable'
});

exports.Prisma.DealerGroupScalarFieldEnum = {
  id: 'id',
  name: 'name',
  contactEmail: 'contactEmail',
  contactPhone: 'contactPhone',
  address: 'address',
  isActive: 'isActive',
  inventoryMode: 'inventoryMode',
  verificationStatus: 'verificationStatus',
  verifiedAt: 'verifiedAt',
  verifiedBy: 'verifiedBy',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.DealerGroupUserScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  groupId: 'groupId',
  createdAt: 'createdAt'
};

exports.Prisma.GroupPermissionScalarFieldEnum = {
  id: 'id',
  groupId: 'groupId',
  dealerId: 'dealerId',
  scope: 'scope',
  granted: 'granted',
  configuredBy: 'configuredBy',
  configuredAt: 'configuredAt'
};

exports.Prisma.VehicleTransferScalarFieldEnum = {
  id: 'id',
  vehicleId: 'vehicleId',
  fromDealerId: 'fromDealerId',
  toDealerId: 'toDealerId',
  initiatedBy: 'initiatedBy',
  notes: 'notes',
  status: 'status',
  createdAt: 'createdAt',
  completedAt: 'completedAt'
};

exports.Prisma.DealerScalarFieldEnum = {
  id: 'id',
  name: 'name',
  contactEmail: 'contactEmail',
  contactPhone: 'contactPhone',
  address: 'address',
  isActive: 'isActive',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt',
  sector: 'sector',
  lmvdNumber: 'lmvdNumber',
  groupId: 'groupId',
  verificationStatus: 'verificationStatus',
  verificationNotes: 'verificationNotes',
  verifiedAt: 'verifiedAt',
  verifiedBy: 'verifiedBy'
};

exports.Prisma.UserScalarFieldEnum = {
  id: 'id',
  email: 'email',
  passwordHash: 'passwordHash',
  name: 'name',
  role: 'role',
  dealerId: 'dealerId',
  isActive: 'isActive',
  createdAt: 'createdAt',
  lastLoginAt: 'lastLoginAt'
};

exports.Prisma.IpWhitelistScalarFieldEnum = {
  id: 'id',
  ipAddress: 'ipAddress',
  label: 'label',
  dealerId: 'dealerId',
  sector: 'sector',
  createdBy: 'createdBy',
  createdAt: 'createdAt'
};

exports.Prisma.PasswordResetScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  token: 'token',
  expiresAt: 'expiresAt',
  usedAt: 'usedAt',
  createdAt: 'createdAt'
};

exports.Prisma.VehicleScalarFieldEnum = {
  id: 'id',
  dealerId: 'dealerId',
  registration: 'registration',
  vin: 'vin',
  make: 'make',
  model: 'model',
  year: 'year',
  engineSize: 'engineSize',
  engineCC: 'engineCC',
  fuelType: 'fuelType',
  fuelConsumption: 'fuelConsumption',
  transmission: 'transmission',
  drivetrain: 'drivetrain',
  bodyType: 'bodyType',
  doors: 'doors',
  seats: 'seats',
  colour: 'colour',
  interiorColour: 'interiorColour',
  mileage: 'mileage',
  safetyRating: 'safetyRating',
  features: 'features',
  stockNumber: 'stockNumber',
  sourceUrl: 'sourceUrl',
  price: 'price',
  wholesalePrice: 'wholesalePrice',
  tradePrice: 'tradePrice',
  showRetailPrice: 'showRetailPrice',
  showWholesalePrice: 'showWholesalePrice',
  showTradePrice: 'showTradePrice',
  description: 'description',
  status: 'status',
  soldAt: 'soldAt',
  syndicationStatus: 'syndicationStatus',
  quidproListingId: 'quidproListingId',
  lastSyncedAt: 'lastSyncedAt',
  nztaDataUsed: 'nztaDataUsed',
  wholesaleAvailable: 'wholesaleAvailable',
  wholesaleListedAt: 'wholesaleListedAt',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.VehiclePhotoScalarFieldEnum = {
  id: 'id',
  vehicleId: 'vehicleId',
  url: 'url',
  thumbnailUrl: 'thumbnailUrl',
  position: 'position',
  createdAt: 'createdAt'
};

exports.Prisma.NztaVehicleScalarFieldEnum = {
  id: 'id',
  registration: 'registration',
  vin: 'vin',
  make: 'make',
  model: 'model',
  year: 'year',
  engineSize: 'engineSize',
  fuelType: 'fuelType',
  bodyType: 'bodyType',
  colour: 'colour',
  lastUpdated: 'lastUpdated'
};

exports.Prisma.SyndicationLogScalarFieldEnum = {
  id: 'id',
  vehicleId: 'vehicleId',
  action: 'action',
  status: 'status',
  message: 'message',
  createdAt: 'createdAt'
};

exports.Prisma.WholesaleDisclosureScalarFieldEnum = {
  id: 'id',
  vehicleId: 'vehicleId',
  engineCondition: 'engineCondition',
  transmissionCondition: 'transmissionCondition',
  brakeCondition: 'brakeCondition',
  suspensionCondition: 'suspensionCondition',
  hasWarningLights: 'hasWarningLights',
  warningLightsDetail: 'warningLightsDetail',
  hasAccidentHistory: 'hasAccidentHistory',
  accidentHistoryDetail: 'accidentHistoryDetail',
  hasFloodDamage: 'hasFloodDamage',
  hasFinanceOwing: 'hasFinanceOwing',
  financeOwingAmount: 'financeOwingAmount',
  hasWof: 'hasWof',
  wofExpiry: 'wofExpiry',
  hasRego: 'hasRego',
  regoExpiry: 'regoExpiry',
  hasServiceHistory: 'hasServiceHistory',
  serviceHistoryDetail: 'serviceHistoryDetail',
  additionalNotes: 'additionalNotes',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.DealerReviewScalarFieldEnum = {
  id: 'id',
  reviewerDealerId: 'reviewerDealerId',
  reviewedDealerId: 'reviewedDealerId',
  tradeId: 'tradeId',
  rating: 'rating',
  title: 'title',
  comment: 'comment',
  communicationRating: 'communicationRating',
  vehicleAccuracyRating: 'vehicleAccuracyRating',
  timelinessRating: 'timelinessRating',
  isVisible: 'isVisible',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.WholesaleTradeScalarFieldEnum = {
  id: 'id',
  vehicleId: 'vehicleId',
  sellerDealerId: 'sellerDealerId',
  buyerDealerId: 'buyerDealerId',
  agreedPrice: 'agreedPrice',
  status: 'status',
  acceptedAt: 'acceptedAt',
  completedAt: 'completedAt',
  cancelledAt: 'cancelledAt',
  cancelledBy: 'cancelledBy',
  cancellationReason: 'cancellationReason',
  sellerNotes: 'sellerNotes',
  buyerNotes: 'buyerNotes',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.EquipmentScalarFieldEnum = {
  id: 'id',
  dealerId: 'dealerId',
  type: 'type',
  brand: 'brand',
  model: 'model',
  year: 'year',
  serialNumber: 'serialNumber',
  horsepower: 'horsepower',
  engineType: 'engineType',
  hours: 'hours',
  ptoType: 'ptoType',
  hydraulicFlow: 'hydraulicFlow',
  liftCapacity: 'liftCapacity',
  width: 'width',
  weight: 'weight',
  condition: 'condition',
  lastServiced: 'lastServiced',
  warrantyExpiry: 'warrantyExpiry',
  price: 'price',
  wholesalePrice: 'wholesalePrice',
  tradePrice: 'tradePrice',
  showRetailPrice: 'showRetailPrice',
  showWholesalePrice: 'showWholesalePrice',
  showTradePrice: 'showTradePrice',
  description: 'description',
  features: 'features',
  stockNumber: 'stockNumber',
  sourceUrl: 'sourceUrl',
  status: 'status',
  soldAt: 'soldAt',
  syndicationStatus: 'syndicationStatus',
  externalListingId: 'externalListingId',
  lastSyncedAt: 'lastSyncedAt',
  wholesaleAvailable: 'wholesaleAvailable',
  wholesaleListedAt: 'wholesaleListedAt',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.EquipmentPhotoScalarFieldEnum = {
  id: 'id',
  equipmentId: 'equipmentId',
  url: 'url',
  thumbnailUrl: 'thumbnailUrl',
  position: 'position',
  createdAt: 'createdAt'
};

exports.Prisma.SortOrder = {
  asc: 'asc',
  desc: 'desc'
};

exports.Prisma.QueryMode = {
  default: 'default',
  insensitive: 'insensitive'
};

exports.Prisma.NullsOrder = {
  first: 'first',
  last: 'last'
};
exports.UserRole = exports.$Enums.UserRole = {
  platform_admin: 'platform_admin',
  group_admin: 'group_admin',
  dealer_admin: 'dealer_admin',
  dealer_user: 'dealer_user'
};

exports.InventoryMode = exports.$Enums.InventoryMode = {
  separate: 'separate',
  shared_pool: 'shared_pool'
};

exports.GroupPermissionScope = exports.$Enums.GroupPermissionScope = {
  inventory_view: 'inventory_view',
  inventory_manage: 'inventory_manage',
  stats_view: 'stats_view',
  users_view: 'users_view',
  users_manage: 'users_manage',
  settings_view: 'settings_view',
  settings_manage: 'settings_manage',
  wholesale_view: 'wholesale_view',
  wholesale_manage: 'wholesale_manage'
};

exports.TransferStatus = exports.$Enums.TransferStatus = {
  pending: 'pending',
  completed: 'completed',
  cancelled: 'cancelled'
};

exports.VehicleStatus = exports.$Enums.VehicleStatus = {
  in_stock: 'in_stock',
  reserved: 'reserved',
  sold: 'sold'
};

exports.SyndicationStatus = exports.$Enums.SyndicationStatus = {
  none: 'none',
  pending: 'pending',
  synced: 'synced',
  error: 'error'
};

exports.VerificationStatus = exports.$Enums.VerificationStatus = {
  unverified: 'unverified',
  pending: 'pending',
  verified: 'verified'
};

exports.TradeStatus = exports.$Enums.TradeStatus = {
  pending: 'pending',
  accepted: 'accepted',
  completed: 'completed',
  cancelled: 'cancelled'
};

exports.DealerSector = exports.$Enums.DealerSector = {
  vehicles: 'vehicles',
  agriculture: 'agriculture'
};

exports.Prisma.ModelName = {
  DealerGroup: 'DealerGroup',
  DealerGroupUser: 'DealerGroupUser',
  GroupPermission: 'GroupPermission',
  VehicleTransfer: 'VehicleTransfer',
  Dealer: 'Dealer',
  User: 'User',
  IpWhitelist: 'IpWhitelist',
  PasswordReset: 'PasswordReset',
  Vehicle: 'Vehicle',
  VehiclePhoto: 'VehiclePhoto',
  NztaVehicle: 'NztaVehicle',
  SyndicationLog: 'SyndicationLog',
  WholesaleDisclosure: 'WholesaleDisclosure',
  DealerReview: 'DealerReview',
  WholesaleTrade: 'WholesaleTrade',
  Equipment: 'Equipment',
  EquipmentPhoto: 'EquipmentPhoto'
};
/**
 * Create the Client
 */
const config = {
  "previewFeatures": [],
  "clientVersion": "7.2.0",
  "engineVersion": "0c8ef2ce45c83248ab3df073180d5eda9e8be7a3",
  "activeProvider": "postgresql",
  "inlineSchema": "// DMS Prisma Schema\n// Dealer Management System - IP-restricted B2B platform for NZ automotive dealers\n\ngenerator client {\n  provider = \"prisma-client-js\"\n}\n\ndatasource db {\n  provider = \"postgresql\"\n}\n\n// User roles for the platform\nenum UserRole {\n  platform_admin\n  group_admin // Can manage subsidiaries based on permissions\n  dealer_admin\n  dealer_user\n}\n\n// Inventory mode for dealer groups\nenum InventoryMode {\n  separate // Each dealer maintains own inventory\n  shared_pool // Vehicles can be transferred easily between group members\n}\n\n// Permission scopes for group access to subsidiaries\nenum GroupPermissionScope {\n  inventory_view\n  inventory_manage\n  stats_view\n  users_view\n  users_manage\n  settings_view\n  settings_manage\n  wholesale_view\n  wholesale_manage\n}\n\n// Vehicle transfer status within dealer groups\nenum TransferStatus {\n  pending\n  completed\n  cancelled\n}\n\n// Vehicle status for inventory management\nenum VehicleStatus {\n  in_stock\n  reserved\n  sold\n}\n\n// Syndication status for Quidpro integration\nenum SyndicationStatus {\n  none\n  pending\n  synced\n  error\n}\n\n// Dealer verification status for wholesale marketplace\nenum VerificationStatus {\n  unverified\n  pending\n  verified\n}\n\n// Wholesale trade status\nenum TradeStatus {\n  pending\n  accepted\n  completed\n  cancelled\n}\n\n// Dealer sector - vehicles or agriculture\nenum DealerSector {\n  vehicles\n  agriculture\n}\n\n// DealerGroup - parent entity owning multiple dealerships (e.g., \"Tristram Group\")\nmodel DealerGroup {\n  id           String  @id @default(cuid())\n  name         String // e.g., \"Tristram Group\"\n  contactEmail String\n  contactPhone String?\n  address      String?\n  isActive     Boolean @default(true)\n\n  // Inventory mode for the group\n  inventoryMode InventoryMode @default(separate)\n\n  // Verification (can cascade to subsidiaries)\n  verificationStatus VerificationStatus @default(unverified)\n  verifiedAt         DateTime?\n  verifiedBy         String?\n\n  // Timestamps\n  createdAt DateTime @default(now())\n  updatedAt DateTime @updatedAt\n\n  // Relations\n  dealers     Dealer[]\n  groupUsers  DealerGroupUser[]\n  permissions GroupPermission[]\n\n  @@index([isActive])\n}\n\n// DealerGroupUser - links users to groups (group_admin level access)\nmodel DealerGroupUser {\n  id        String   @id @default(cuid())\n  userId    String\n  groupId   String\n  createdAt DateTime @default(now())\n\n  // Relations\n  user  User        @relation(fields: [userId], references: [id], onDelete: Cascade)\n  group DealerGroup @relation(fields: [groupId], references: [id], onDelete: Cascade)\n\n  @@unique([userId, groupId])\n  @@index([userId])\n  @@index([groupId])\n}\n\n// GroupPermission - configurable permissions per subsidiary\nmodel GroupPermission {\n  id       String               @id @default(cuid())\n  groupId  String\n  dealerId String // The subsidiary this applies to\n  scope    GroupPermissionScope\n  granted  Boolean              @default(true)\n\n  // Who configured this (subsidiary admin)\n  configuredBy String?\n  configuredAt DateTime @default(now())\n\n  // Relations\n  group  DealerGroup @relation(fields: [groupId], references: [id], onDelete: Cascade)\n  dealer Dealer      @relation(fields: [dealerId], references: [id], onDelete: Cascade)\n\n  @@unique([groupId, dealerId, scope])\n  @@index([groupId])\n  @@index([dealerId])\n}\n\n// VehicleTransfer - track intra-group vehicle movements\nmodel VehicleTransfer {\n  id           String @id @default(cuid())\n  vehicleId    String\n  fromDealerId String\n  toDealerId   String\n  initiatedBy  String // User ID\n\n  // Transfer details\n  notes  String?        @db.Text\n  status TransferStatus @default(pending)\n\n  // Timestamps\n  createdAt   DateTime  @default(now())\n  completedAt DateTime?\n\n  // Relations\n  vehicle    Vehicle @relation(fields: [vehicleId], references: [id])\n  fromDealer Dealer  @relation(\"TransfersOut\", fields: [fromDealerId], references: [id])\n  toDealer   Dealer  @relation(\"TransfersIn\", fields: [toDealerId], references: [id])\n\n  @@index([vehicleId])\n  @@index([fromDealerId])\n  @@index([toDealerId])\n  @@index([status])\n}\n\n// Dealer - a dealership/business on the platform\nmodel Dealer {\n  id           String   @id @default(cuid())\n  name         String\n  contactEmail String\n  contactPhone String?\n  address      String?\n  isActive     Boolean  @default(true)\n  createdAt    DateTime @default(now())\n  updatedAt    DateTime @updatedAt\n\n  // Sector - vehicles or agriculture (completely separate)\n  sector DealerSector @default(vehicles)\n\n  // LMVD (Licensed Motor Vehicle Dealer) registration - optional but displayed if provided\n  lmvdNumber String? // e.g., \"LMVD12345\"\n\n  // Dealer Group membership (optional)\n  groupId String?\n  group   DealerGroup? @relation(fields: [groupId], references: [id])\n\n  // Wholesale verification\n  verificationStatus VerificationStatus @default(unverified)\n  verificationNotes  String?            @db.Text\n  verifiedAt         DateTime?\n  verifiedBy         String? // User ID who verified\n\n  // Relations\n  users            User[]\n  ipWhitelist      IpWhitelist[]\n  vehicles         Vehicle[]\n  equipment        Equipment[] // Agriculture equipment\n  reviewsGiven     DealerReview[]    @relation(\"ReviewsGiven\")\n  reviewsReceived  DealerReview[]    @relation(\"ReviewsReceived\")\n  tradesAsSeller   WholesaleTrade[]  @relation(\"Seller\")\n  tradesAsBuyer    WholesaleTrade[]  @relation(\"Buyer\")\n  groupPermissions GroupPermission[]\n  transfersOut     VehicleTransfer[] @relation(\"TransfersOut\")\n  transfersIn      VehicleTransfer[] @relation(\"TransfersIn\")\n\n  @@index([groupId])\n  @@index([sector])\n}\n\n// User - individuals who can log into the platform\nmodel User {\n  id           String    @id @default(cuid())\n  email        String    @unique\n  passwordHash String\n  name         String\n  role         UserRole  @default(dealer_user)\n  dealerId     String?\n  isActive     Boolean   @default(true)\n  createdAt    DateTime  @default(now())\n  lastLoginAt  DateTime?\n\n  // Relations\n  dealer           Dealer?           @relation(fields: [dealerId], references: [id])\n  groupMemberships DealerGroupUser[]\n\n  @@index([dealerId])\n  @@index([email])\n}\n\n// IP Whitelist - controls access to the platform\nmodel IpWhitelist {\n  id        String        @id @default(cuid())\n  ipAddress String\n  label     String\n  dealerId  String? // null = global (applies to all dealers)\n  sector    DealerSector? // null = applies to both sectors\n  createdBy String\n  createdAt DateTime      @default(now())\n\n  // Relations\n  dealer Dealer? @relation(fields: [dealerId], references: [id])\n\n  // Unique constraint: same IP can't be added twice for same dealer\n  @@unique([ipAddress, dealerId])\n  @@index([ipAddress])\n  @@index([sector])\n}\n\n// Password Reset tokens\nmodel PasswordReset {\n  id        String    @id @default(cuid())\n  userId    String\n  token     String    @unique\n  expiresAt DateTime\n  usedAt    DateTime?\n  createdAt DateTime  @default(now())\n\n  @@index([token])\n  @@index([userId])\n}\n\n// Vehicle - inventory items owned by dealers\nmodel Vehicle {\n  id       String @id @default(cuid())\n  dealerId String\n\n  // Core vehicle details\n  registration String? // NZ rego plate (optional for imports)\n  vin          String? // Vehicle identification number\n  make         String\n  model        String\n  year         Int\n\n  // Specifications\n  engineSize      String? // e.g., \"2.0L\"\n  engineCC        Int? // Engine size in CC (e.g., 1395)\n  fuelType        String? // e.g., \"Petrol\", \"Diesel\", \"Electric\", \"Hybrid\"\n  fuelConsumption Float? // L/100km\n  transmission    String? // e.g., \"Automatic\", \"Manual\"\n  drivetrain      String? // \"FWD\", \"RWD\", \"AWD\", \"4WD\"\n  bodyType        String? // e.g., \"Sedan\", \"SUV\", \"Ute\"\n  doors           Int? // Number of doors\n  seats           Int? // Seating capacity\n  colour          String?\n  interiorColour  String?\n  mileage         Int? // Odometer in km\n  safetyRating    Int? // ANCAP stars (1-5) or safety score\n  features        String? @db.Text // JSON array of features\n  stockNumber     String? // Dealer's internal stock number\n  sourceUrl       String? // Original listing URL if scraped\n\n  // Listing details - prices in cents (e.g., 2499000 = $24,990)\n  price          Int // Retail price\n  wholesalePrice Int? // Wholesale price for dealer-to-dealer\n  tradePrice     Int? // Trade-in price (as-is, where-is)\n\n  // Price visibility toggles\n  showRetailPrice    Boolean @default(true)\n  showWholesalePrice Boolean @default(false)\n  showTradePrice     Boolean @default(false)\n\n  description String? @db.Text\n\n  // Status\n  status VehicleStatus @default(in_stock)\n  soldAt DateTime?\n\n  // Syndication\n  syndicationStatus SyndicationStatus @default(none)\n  quidproListingId  String? // External ID from Quidpro\n  lastSyncedAt      DateTime?\n\n  // NZTA data tracking\n  nztaDataUsed Boolean @default(false)\n\n  // Wholesale marketplace\n  wholesaleAvailable Boolean   @default(false)\n  wholesaleListedAt  DateTime?\n\n  // Timestamps\n  createdAt DateTime @default(now())\n  updatedAt DateTime @updatedAt\n\n  // Relations\n  dealer     Dealer               @relation(fields: [dealerId], references: [id])\n  photos     VehiclePhoto[]\n  disclosure WholesaleDisclosure?\n  trades     WholesaleTrade[]\n  transfers  VehicleTransfer[]\n\n  @@index([dealerId])\n  @@index([status])\n  @@index([registration])\n  @@index([make, model])\n  @@index([wholesaleAvailable])\n}\n\n// VehiclePhoto - photos attached to vehicles\nmodel VehiclePhoto {\n  id           String   @id @default(cuid())\n  vehicleId    String\n  url          String // Path to stored image\n  thumbnailUrl String? // Path to thumbnail\n  position     Int      @default(0) // Order in gallery (0 = primary)\n  createdAt    DateTime @default(now())\n\n  // Relations\n  vehicle Vehicle @relation(fields: [vehicleId], references: [id], onDelete: Cascade)\n\n  @@index([vehicleId])\n}\n\n// NZTA Vehicle Registry - cached vehicle data from NZTA\nmodel NztaVehicle {\n  id           String  @id @default(cuid())\n  registration String  @unique\n  vin          String?\n  make         String?\n  model        String?\n  year         Int?\n  engineSize   String?\n  fuelType     String?\n  bodyType     String?\n  colour       String?\n\n  // Sync tracking\n  lastUpdated DateTime @default(now())\n\n  @@index([registration])\n  @@index([vin])\n}\n\n// Syndication Log - tracks sync events with Quidpro\nmodel SyndicationLog {\n  id        String   @id @default(cuid())\n  vehicleId String\n  action    String // \"create\", \"update\", \"delete\"\n  status    String // \"success\", \"error\"\n  message   String?  @db.Text\n  createdAt DateTime @default(now())\n\n  @@index([vehicleId])\n  @@index([createdAt])\n}\n\n// Wholesale Disclosure - mandatory disclosure checklist for wholesale vehicles\nmodel WholesaleDisclosure {\n  id        String @id @default(cuid())\n  vehicleId String @unique\n\n  // Mechanical condition\n  engineCondition       String // \"good\", \"fair\", \"poor\", \"unknown\"\n  transmissionCondition String // \"good\", \"fair\", \"poor\", \"unknown\"\n  brakeCondition        String // \"good\", \"fair\", \"poor\", \"unknown\"\n  suspensionCondition   String // \"good\", \"fair\", \"poor\", \"unknown\"\n\n  // Known issues\n  hasWarningLights      Boolean @default(false)\n  warningLightsDetail   String? @db.Text\n  hasAccidentHistory    Boolean @default(false)\n  accidentHistoryDetail String? @db.Text\n  hasFloodDamage        Boolean @default(false)\n  hasFinanceOwing       Boolean @default(false)\n  financeOwingAmount    Int? // Amount in cents\n\n  // Documentation\n  hasWof               Boolean   @default(false)\n  wofExpiry            DateTime?\n  hasRego              Boolean   @default(false)\n  regoExpiry           DateTime?\n  hasServiceHistory    Boolean   @default(false)\n  serviceHistoryDetail String?   @db.Text\n\n  // Additional notes\n  additionalNotes String? @db.Text\n\n  // Timestamps\n  createdAt DateTime @default(now())\n  updatedAt DateTime @updatedAt\n\n  // Relations\n  vehicle Vehicle @relation(fields: [vehicleId], references: [id], onDelete: Cascade)\n}\n\n// Dealer Review - dealer-to-dealer reviews after wholesale trades\nmodel DealerReview {\n  id               String  @id @default(cuid())\n  reviewerDealerId String\n  reviewedDealerId String\n  tradeId          String? // Optional link to specific trade\n\n  // Rating (1-5 stars)\n  rating Int // 1-5\n\n  // Review content\n  title   String?\n  comment String? @db.Text\n\n  // Review aspects\n  communicationRating   Int? // 1-5\n  vehicleAccuracyRating Int? // 1-5\n  timelinessRating      Int? // 1-5\n\n  // Moderation\n  isVisible Boolean @default(true)\n\n  // Timestamps\n  createdAt DateTime @default(now())\n  updatedAt DateTime @updatedAt\n\n  // Relations\n  reviewerDealer Dealer          @relation(\"ReviewsGiven\", fields: [reviewerDealerId], references: [id])\n  reviewedDealer Dealer          @relation(\"ReviewsReceived\", fields: [reviewedDealerId], references: [id])\n  trade          WholesaleTrade? @relation(fields: [tradeId], references: [id])\n\n  @@index([reviewerDealerId])\n  @@index([reviewedDealerId])\n  @@index([rating])\n}\n\n// Wholesale Trade - tracks wholesale transactions between dealers\nmodel WholesaleTrade {\n  id             String @id @default(cuid())\n  vehicleId      String\n  sellerDealerId String\n  buyerDealerId  String\n\n  // Trade details\n  agreedPrice Int // Price in cents\n  status      TradeStatus @default(pending)\n\n  // Status timestamps\n  acceptedAt         DateTime?\n  completedAt        DateTime?\n  cancelledAt        DateTime?\n  cancelledBy        String? // Dealer ID who cancelled\n  cancellationReason String?   @db.Text\n\n  // Notes\n  sellerNotes String? @db.Text\n  buyerNotes  String? @db.Text\n\n  // Timestamps\n  createdAt DateTime @default(now())\n  updatedAt DateTime @updatedAt\n\n  // Relations\n  vehicle      Vehicle        @relation(fields: [vehicleId], references: [id])\n  sellerDealer Dealer         @relation(\"Seller\", fields: [sellerDealerId], references: [id])\n  buyerDealer  Dealer         @relation(\"Buyer\", fields: [buyerDealerId], references: [id])\n  reviews      DealerReview[]\n\n  @@index([vehicleId])\n  @@index([sellerDealerId])\n  @@index([buyerDealerId])\n  @@index([status])\n  @@index([createdAt])\n}\n\n// ============================================================================\n// AGRICULTURE SECTOR MODELS\n// ============================================================================\n\n// Equipment - agriculture/farming equipment inventory\nmodel Equipment {\n  id       String @id @default(cuid())\n  dealerId String\n  dealer   Dealer @relation(fields: [dealerId], references: [id])\n\n  // Equipment identification\n  type         String // Tractor, Combine Harvester, Telehandler, etc.\n  brand        String // Deutz-Fahr, Kverneland, Kioti, JCB\n  model        String\n  year         Int\n  serialNumber String?\n\n  // Specifications\n  horsepower    Int? // Engine horsepower\n  engineType    String? // Diesel, Petrol, Electric\n  hours         Int? // Engine hours (key wear metric for equipment)\n  ptoType       String? // 540, 1000, Ground-speed PTO\n  hydraulicFlow Int? // Hydraulic flow in L/min\n  liftCapacity  Int? // Lift capacity in kg\n  width         Int? // Width in mm (for implements)\n  weight        Int? // Weight in kg\n\n  // Condition & service\n  condition      String // New, Excellent, Good, Fair, Poor\n  lastServiced   DateTime?\n  warrantyExpiry DateTime?\n\n  // Listing details - prices in cents (e.g., 4999900 = $49,999)\n  price          Int // Retail price\n  wholesalePrice Int? // Wholesale price for dealer-to-dealer\n  tradePrice     Int? // Trade-in price (as-is, where-is)\n\n  // Price visibility toggles\n  showRetailPrice    Boolean @default(true)\n  showWholesalePrice Boolean @default(false)\n  showTradePrice     Boolean @default(false)\n\n  description String? @db.Text\n  features    String? @db.Text // JSON array of features\n  stockNumber String? // Dealer's internal stock number\n  sourceUrl   String? // Original listing URL if scraped\n\n  // Status\n  status VehicleStatus @default(in_stock) // Reuse vehicle status\n  soldAt DateTime?\n\n  // Syndication (for future Power Farming integration)\n  syndicationStatus SyndicationStatus @default(none)\n  externalListingId String? // External ID from marketplace\n  lastSyncedAt      DateTime?\n\n  // Wholesale marketplace\n  wholesaleAvailable Boolean   @default(false)\n  wholesaleListedAt  DateTime?\n\n  // Photos\n  photos EquipmentPhoto[]\n\n  // Timestamps\n  createdAt DateTime @default(now())\n  updatedAt DateTime @updatedAt\n\n  @@index([dealerId])\n  @@index([status])\n  @@index([type])\n  @@index([brand])\n  @@index([wholesaleAvailable])\n}\n\n// EquipmentPhoto - photos attached to equipment\nmodel EquipmentPhoto {\n  id           String    @id @default(cuid())\n  equipmentId  String\n  equipment    Equipment @relation(fields: [equipmentId], references: [id], onDelete: Cascade)\n  url          String // Path to stored image\n  thumbnailUrl String? // Path to thumbnail\n  position     Int       @default(0) // Order in gallery (0 = primary)\n  createdAt    DateTime  @default(now())\n\n  @@index([equipmentId])\n}\n"
}

config.runtimeDataModel = JSON.parse("{\"models\":{\"DealerGroup\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"contactEmail\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"contactPhone\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"address\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"isActive\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"inventoryMode\",\"kind\":\"enum\",\"type\":\"InventoryMode\"},{\"name\":\"verificationStatus\",\"kind\":\"enum\",\"type\":\"VerificationStatus\"},{\"name\":\"verifiedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"verifiedBy\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"dealers\",\"kind\":\"object\",\"type\":\"Dealer\",\"relationName\":\"DealerToDealerGroup\"},{\"name\":\"groupUsers\",\"kind\":\"object\",\"type\":\"DealerGroupUser\",\"relationName\":\"DealerGroupToDealerGroupUser\"},{\"name\":\"permissions\",\"kind\":\"object\",\"type\":\"GroupPermission\",\"relationName\":\"DealerGroupToGroupPermission\"}],\"dbName\":null},\"DealerGroupUser\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"groupId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"DealerGroupUserToUser\"},{\"name\":\"group\",\"kind\":\"object\",\"type\":\"DealerGroup\",\"relationName\":\"DealerGroupToDealerGroupUser\"}],\"dbName\":null},\"GroupPermission\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"groupId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"dealerId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"scope\",\"kind\":\"enum\",\"type\":\"GroupPermissionScope\"},{\"name\":\"granted\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"configuredBy\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"configuredAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"group\",\"kind\":\"object\",\"type\":\"DealerGroup\",\"relationName\":\"DealerGroupToGroupPermission\"},{\"name\":\"dealer\",\"kind\":\"object\",\"type\":\"Dealer\",\"relationName\":\"DealerToGroupPermission\"}],\"dbName\":null},\"VehicleTransfer\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"vehicleId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"fromDealerId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"toDealerId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"initiatedBy\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"notes\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"status\",\"kind\":\"enum\",\"type\":\"TransferStatus\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"completedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"vehicle\",\"kind\":\"object\",\"type\":\"Vehicle\",\"relationName\":\"VehicleToVehicleTransfer\"},{\"name\":\"fromDealer\",\"kind\":\"object\",\"type\":\"Dealer\",\"relationName\":\"TransfersOut\"},{\"name\":\"toDealer\",\"kind\":\"object\",\"type\":\"Dealer\",\"relationName\":\"TransfersIn\"}],\"dbName\":null},\"Dealer\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"contactEmail\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"contactPhone\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"address\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"isActive\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"sector\",\"kind\":\"enum\",\"type\":\"DealerSector\"},{\"name\":\"lmvdNumber\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"groupId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"group\",\"kind\":\"object\",\"type\":\"DealerGroup\",\"relationName\":\"DealerToDealerGroup\"},{\"name\":\"verificationStatus\",\"kind\":\"enum\",\"type\":\"VerificationStatus\"},{\"name\":\"verificationNotes\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"verifiedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"verifiedBy\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"users\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"DealerToUser\"},{\"name\":\"ipWhitelist\",\"kind\":\"object\",\"type\":\"IpWhitelist\",\"relationName\":\"DealerToIpWhitelist\"},{\"name\":\"vehicles\",\"kind\":\"object\",\"type\":\"Vehicle\",\"relationName\":\"DealerToVehicle\"},{\"name\":\"equipment\",\"kind\":\"object\",\"type\":\"Equipment\",\"relationName\":\"DealerToEquipment\"},{\"name\":\"reviewsGiven\",\"kind\":\"object\",\"type\":\"DealerReview\",\"relationName\":\"ReviewsGiven\"},{\"name\":\"reviewsReceived\",\"kind\":\"object\",\"type\":\"DealerReview\",\"relationName\":\"ReviewsReceived\"},{\"name\":\"tradesAsSeller\",\"kind\":\"object\",\"type\":\"WholesaleTrade\",\"relationName\":\"Seller\"},{\"name\":\"tradesAsBuyer\",\"kind\":\"object\",\"type\":\"WholesaleTrade\",\"relationName\":\"Buyer\"},{\"name\":\"groupPermissions\",\"kind\":\"object\",\"type\":\"GroupPermission\",\"relationName\":\"DealerToGroupPermission\"},{\"name\":\"transfersOut\",\"kind\":\"object\",\"type\":\"VehicleTransfer\",\"relationName\":\"TransfersOut\"},{\"name\":\"transfersIn\",\"kind\":\"object\",\"type\":\"VehicleTransfer\",\"relationName\":\"TransfersIn\"}],\"dbName\":null},\"User\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"email\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"passwordHash\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"role\",\"kind\":\"enum\",\"type\":\"UserRole\"},{\"name\":\"dealerId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"isActive\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"lastLoginAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"dealer\",\"kind\":\"object\",\"type\":\"Dealer\",\"relationName\":\"DealerToUser\"},{\"name\":\"groupMemberships\",\"kind\":\"object\",\"type\":\"DealerGroupUser\",\"relationName\":\"DealerGroupUserToUser\"}],\"dbName\":null},\"IpWhitelist\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"ipAddress\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"label\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"dealerId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"sector\",\"kind\":\"enum\",\"type\":\"DealerSector\"},{\"name\":\"createdBy\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"dealer\",\"kind\":\"object\",\"type\":\"Dealer\",\"relationName\":\"DealerToIpWhitelist\"}],\"dbName\":null},\"PasswordReset\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"token\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"expiresAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"usedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":null},\"Vehicle\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"dealerId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"registration\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"vin\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"make\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"model\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"year\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"engineSize\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"engineCC\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"fuelType\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"fuelConsumption\",\"kind\":\"scalar\",\"type\":\"Float\"},{\"name\":\"transmission\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"drivetrain\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"bodyType\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"doors\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"seats\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"colour\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"interiorColour\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"mileage\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"safetyRating\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"features\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"stockNumber\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"sourceUrl\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"price\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"wholesalePrice\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"tradePrice\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"showRetailPrice\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"showWholesalePrice\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"showTradePrice\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"description\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"status\",\"kind\":\"enum\",\"type\":\"VehicleStatus\"},{\"name\":\"soldAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"syndicationStatus\",\"kind\":\"enum\",\"type\":\"SyndicationStatus\"},{\"name\":\"quidproListingId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"lastSyncedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"nztaDataUsed\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"wholesaleAvailable\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"wholesaleListedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"dealer\",\"kind\":\"object\",\"type\":\"Dealer\",\"relationName\":\"DealerToVehicle\"},{\"name\":\"photos\",\"kind\":\"object\",\"type\":\"VehiclePhoto\",\"relationName\":\"VehicleToVehiclePhoto\"},{\"name\":\"disclosure\",\"kind\":\"object\",\"type\":\"WholesaleDisclosure\",\"relationName\":\"VehicleToWholesaleDisclosure\"},{\"name\":\"trades\",\"kind\":\"object\",\"type\":\"WholesaleTrade\",\"relationName\":\"VehicleToWholesaleTrade\"},{\"name\":\"transfers\",\"kind\":\"object\",\"type\":\"VehicleTransfer\",\"relationName\":\"VehicleToVehicleTransfer\"}],\"dbName\":null},\"VehiclePhoto\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"vehicleId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"url\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"thumbnailUrl\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"position\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"vehicle\",\"kind\":\"object\",\"type\":\"Vehicle\",\"relationName\":\"VehicleToVehiclePhoto\"}],\"dbName\":null},\"NztaVehicle\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"registration\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"vin\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"make\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"model\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"year\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"engineSize\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"fuelType\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"bodyType\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"colour\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"lastUpdated\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":null},\"SyndicationLog\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"vehicleId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"action\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"status\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"message\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":null},\"WholesaleDisclosure\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"vehicleId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"engineCondition\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"transmissionCondition\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"brakeCondition\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"suspensionCondition\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"hasWarningLights\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"warningLightsDetail\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"hasAccidentHistory\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"accidentHistoryDetail\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"hasFloodDamage\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"hasFinanceOwing\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"financeOwingAmount\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"hasWof\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"wofExpiry\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"hasRego\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"regoExpiry\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"hasServiceHistory\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"serviceHistoryDetail\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"additionalNotes\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"vehicle\",\"kind\":\"object\",\"type\":\"Vehicle\",\"relationName\":\"VehicleToWholesaleDisclosure\"}],\"dbName\":null},\"DealerReview\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"reviewerDealerId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"reviewedDealerId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"tradeId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"rating\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"title\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"comment\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"communicationRating\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"vehicleAccuracyRating\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"timelinessRating\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"isVisible\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"reviewerDealer\",\"kind\":\"object\",\"type\":\"Dealer\",\"relationName\":\"ReviewsGiven\"},{\"name\":\"reviewedDealer\",\"kind\":\"object\",\"type\":\"Dealer\",\"relationName\":\"ReviewsReceived\"},{\"name\":\"trade\",\"kind\":\"object\",\"type\":\"WholesaleTrade\",\"relationName\":\"DealerReviewToWholesaleTrade\"}],\"dbName\":null},\"WholesaleTrade\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"vehicleId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"sellerDealerId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"buyerDealerId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"agreedPrice\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"status\",\"kind\":\"enum\",\"type\":\"TradeStatus\"},{\"name\":\"acceptedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"completedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"cancelledAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"cancelledBy\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"cancellationReason\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"sellerNotes\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"buyerNotes\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"vehicle\",\"kind\":\"object\",\"type\":\"Vehicle\",\"relationName\":\"VehicleToWholesaleTrade\"},{\"name\":\"sellerDealer\",\"kind\":\"object\",\"type\":\"Dealer\",\"relationName\":\"Seller\"},{\"name\":\"buyerDealer\",\"kind\":\"object\",\"type\":\"Dealer\",\"relationName\":\"Buyer\"},{\"name\":\"reviews\",\"kind\":\"object\",\"type\":\"DealerReview\",\"relationName\":\"DealerReviewToWholesaleTrade\"}],\"dbName\":null},\"Equipment\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"dealerId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"dealer\",\"kind\":\"object\",\"type\":\"Dealer\",\"relationName\":\"DealerToEquipment\"},{\"name\":\"type\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"brand\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"model\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"year\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"serialNumber\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"horsepower\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"engineType\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"hours\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"ptoType\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"hydraulicFlow\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"liftCapacity\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"width\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"weight\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"condition\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"lastServiced\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"warrantyExpiry\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"price\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"wholesalePrice\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"tradePrice\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"showRetailPrice\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"showWholesalePrice\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"showTradePrice\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"description\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"features\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"stockNumber\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"sourceUrl\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"status\",\"kind\":\"enum\",\"type\":\"VehicleStatus\"},{\"name\":\"soldAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"syndicationStatus\",\"kind\":\"enum\",\"type\":\"SyndicationStatus\"},{\"name\":\"externalListingId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"lastSyncedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"wholesaleAvailable\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"wholesaleListedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"photos\",\"kind\":\"object\",\"type\":\"EquipmentPhoto\",\"relationName\":\"EquipmentToEquipmentPhoto\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":null},\"EquipmentPhoto\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"equipmentId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"equipment\",\"kind\":\"object\",\"type\":\"Equipment\",\"relationName\":\"EquipmentToEquipmentPhoto\"},{\"name\":\"url\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"thumbnailUrl\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"position\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":null}},\"enums\":{},\"types\":{}}")
defineDmmfProperty(exports.Prisma, config.runtimeDataModel)
config.compilerWasm = {
      getRuntime: async () => require('./query_compiler_bg.js'),
      getQueryCompilerWasmModule: async () => {
        const { Buffer } = require('node:buffer')
        const { wasm } = require('./query_compiler_bg.wasm-base64.js')
        const queryCompilerWasmFileBytes = Buffer.from(wasm, 'base64')

        return new WebAssembly.Module(queryCompilerWasmFileBytes)
      }
    }

const PrismaClient = getPrismaClient(config)
exports.PrismaClient = PrismaClient
Object.assign(exports, Prisma)
