-- CreateEnum
CREATE TYPE "UserRole" AS ENUM ('platform_admin', 'dealer_admin', 'dealer_user');

-- CreateEnum
CREATE TYPE "VehicleStatus" AS ENUM ('in_stock', 'reserved', 'sold');

-- CreateEnum
CREATE TYPE "SyndicationStatus" AS ENUM ('none', 'pending', 'synced', 'error');

-- CreateEnum
CREATE TYPE "VerificationStatus" AS ENUM ('unverified', 'pending', 'verified');

-- CreateEnum
CREATE TYPE "TradeStatus" AS ENUM ('pending', 'accepted', 'completed', 'cancelled');

-- CreateTable
CREATE TABLE "Dealer" (
    "id" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "contactEmail" TEXT NOT NULL,
    "contactPhone" TEXT,
    "address" TEXT,
    "isActive" BOOLEAN NOT NULL DEFAULT true,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL,
    "verificationStatus" "VerificationStatus" NOT NULL DEFAULT 'unverified',
    "verificationNotes" TEXT,
    "verifiedAt" TIMESTAMP(3),
    "verifiedBy" TEXT,

    CONSTRAINT "Dealer_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "User" (
    "id" TEXT NOT NULL,
    "email" TEXT NOT NULL,
    "passwordHash" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "role" "UserRole" NOT NULL DEFAULT 'dealer_user',
    "dealerId" TEXT,
    "isActive" BOOLEAN NOT NULL DEFAULT true,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "lastLoginAt" TIMESTAMP(3),

    CONSTRAINT "User_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "IpWhitelist" (
    "id" TEXT NOT NULL,
    "ipAddress" TEXT NOT NULL,
    "label" TEXT NOT NULL,
    "dealerId" TEXT,
    "createdBy" TEXT NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "IpWhitelist_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "PasswordReset" (
    "id" TEXT NOT NULL,
    "userId" TEXT NOT NULL,
    "token" TEXT NOT NULL,
    "expiresAt" TIMESTAMP(3) NOT NULL,
    "usedAt" TIMESTAMP(3),
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "PasswordReset_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Vehicle" (
    "id" TEXT NOT NULL,
    "dealerId" TEXT NOT NULL,
    "registration" TEXT,
    "vin" TEXT,
    "make" TEXT NOT NULL,
    "model" TEXT NOT NULL,
    "year" INTEGER NOT NULL,
    "engineSize" TEXT,
    "fuelType" TEXT,
    "transmission" TEXT,
    "bodyType" TEXT,
    "colour" TEXT,
    "mileage" INTEGER,
    "price" INTEGER NOT NULL,
    "description" TEXT,
    "status" "VehicleStatus" NOT NULL DEFAULT 'in_stock',
    "soldAt" TIMESTAMP(3),
    "syndicationStatus" "SyndicationStatus" NOT NULL DEFAULT 'none',
    "quidproListingId" TEXT,
    "lastSyncedAt" TIMESTAMP(3),
    "nztaDataUsed" BOOLEAN NOT NULL DEFAULT false,
    "wholesaleAvailable" BOOLEAN NOT NULL DEFAULT false,
    "wholesalePrice" INTEGER,
    "wholesaleListedAt" TIMESTAMP(3),
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "Vehicle_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "VehiclePhoto" (
    "id" TEXT NOT NULL,
    "vehicleId" TEXT NOT NULL,
    "url" TEXT NOT NULL,
    "thumbnailUrl" TEXT,
    "position" INTEGER NOT NULL DEFAULT 0,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "VehiclePhoto_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "NztaVehicle" (
    "id" TEXT NOT NULL,
    "registration" TEXT NOT NULL,
    "vin" TEXT,
    "make" TEXT,
    "model" TEXT,
    "year" INTEGER,
    "engineSize" TEXT,
    "fuelType" TEXT,
    "bodyType" TEXT,
    "colour" TEXT,
    "lastUpdated" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "NztaVehicle_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "SyndicationLog" (
    "id" TEXT NOT NULL,
    "vehicleId" TEXT NOT NULL,
    "action" TEXT NOT NULL,
    "status" TEXT NOT NULL,
    "message" TEXT,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "SyndicationLog_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "WholesaleDisclosure" (
    "id" TEXT NOT NULL,
    "vehicleId" TEXT NOT NULL,
    "engineCondition" TEXT NOT NULL,
    "transmissionCondition" TEXT NOT NULL,
    "brakeCondition" TEXT NOT NULL,
    "suspensionCondition" TEXT NOT NULL,
    "hasWarningLights" BOOLEAN NOT NULL DEFAULT false,
    "warningLightsDetail" TEXT,
    "hasAccidentHistory" BOOLEAN NOT NULL DEFAULT false,
    "accidentHistoryDetail" TEXT,
    "hasFloodDamage" BOOLEAN NOT NULL DEFAULT false,
    "hasFinanceOwing" BOOLEAN NOT NULL DEFAULT false,
    "financeOwingAmount" INTEGER,
    "hasWof" BOOLEAN NOT NULL DEFAULT false,
    "wofExpiry" TIMESTAMP(3),
    "hasRego" BOOLEAN NOT NULL DEFAULT false,
    "regoExpiry" TIMESTAMP(3),
    "hasServiceHistory" BOOLEAN NOT NULL DEFAULT false,
    "serviceHistoryDetail" TEXT,
    "additionalNotes" TEXT,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "WholesaleDisclosure_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "DealerReview" (
    "id" TEXT NOT NULL,
    "reviewerDealerId" TEXT NOT NULL,
    "reviewedDealerId" TEXT NOT NULL,
    "tradeId" TEXT,
    "rating" INTEGER NOT NULL,
    "title" TEXT,
    "comment" TEXT,
    "communicationRating" INTEGER,
    "vehicleAccuracyRating" INTEGER,
    "timelinessRating" INTEGER,
    "isVisible" BOOLEAN NOT NULL DEFAULT true,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "DealerReview_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "WholesaleTrade" (
    "id" TEXT NOT NULL,
    "vehicleId" TEXT NOT NULL,
    "sellerDealerId" TEXT NOT NULL,
    "buyerDealerId" TEXT NOT NULL,
    "agreedPrice" INTEGER NOT NULL,
    "status" "TradeStatus" NOT NULL DEFAULT 'pending',
    "acceptedAt" TIMESTAMP(3),
    "completedAt" TIMESTAMP(3),
    "cancelledAt" TIMESTAMP(3),
    "cancelledBy" TEXT,
    "cancellationReason" TEXT,
    "sellerNotes" TEXT,
    "buyerNotes" TEXT,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "WholesaleTrade_pkey" PRIMARY KEY ("id")
);

-- CreateIndex
CREATE UNIQUE INDEX "User_email_key" ON "User"("email");

-- CreateIndex
CREATE INDEX "User_dealerId_idx" ON "User"("dealerId");

-- CreateIndex
CREATE INDEX "User_email_idx" ON "User"("email");

-- CreateIndex
CREATE INDEX "IpWhitelist_ipAddress_idx" ON "IpWhitelist"("ipAddress");

-- CreateIndex
CREATE UNIQUE INDEX "IpWhitelist_ipAddress_dealerId_key" ON "IpWhitelist"("ipAddress", "dealerId");

-- CreateIndex
CREATE UNIQUE INDEX "PasswordReset_token_key" ON "PasswordReset"("token");

-- CreateIndex
CREATE INDEX "PasswordReset_token_idx" ON "PasswordReset"("token");

-- CreateIndex
CREATE INDEX "PasswordReset_userId_idx" ON "PasswordReset"("userId");

-- CreateIndex
CREATE INDEX "Vehicle_dealerId_idx" ON "Vehicle"("dealerId");

-- CreateIndex
CREATE INDEX "Vehicle_status_idx" ON "Vehicle"("status");

-- CreateIndex
CREATE INDEX "Vehicle_registration_idx" ON "Vehicle"("registration");

-- CreateIndex
CREATE INDEX "Vehicle_make_model_idx" ON "Vehicle"("make", "model");

-- CreateIndex
CREATE INDEX "Vehicle_wholesaleAvailable_idx" ON "Vehicle"("wholesaleAvailable");

-- CreateIndex
CREATE INDEX "VehiclePhoto_vehicleId_idx" ON "VehiclePhoto"("vehicleId");

-- CreateIndex
CREATE UNIQUE INDEX "NztaVehicle_registration_key" ON "NztaVehicle"("registration");

-- CreateIndex
CREATE INDEX "NztaVehicle_registration_idx" ON "NztaVehicle"("registration");

-- CreateIndex
CREATE INDEX "NztaVehicle_vin_idx" ON "NztaVehicle"("vin");

-- CreateIndex
CREATE INDEX "SyndicationLog_vehicleId_idx" ON "SyndicationLog"("vehicleId");

-- CreateIndex
CREATE INDEX "SyndicationLog_createdAt_idx" ON "SyndicationLog"("createdAt");

-- CreateIndex
CREATE UNIQUE INDEX "WholesaleDisclosure_vehicleId_key" ON "WholesaleDisclosure"("vehicleId");

-- CreateIndex
CREATE INDEX "DealerReview_reviewerDealerId_idx" ON "DealerReview"("reviewerDealerId");

-- CreateIndex
CREATE INDEX "DealerReview_reviewedDealerId_idx" ON "DealerReview"("reviewedDealerId");

-- CreateIndex
CREATE INDEX "DealerReview_rating_idx" ON "DealerReview"("rating");

-- CreateIndex
CREATE INDEX "WholesaleTrade_vehicleId_idx" ON "WholesaleTrade"("vehicleId");

-- CreateIndex
CREATE INDEX "WholesaleTrade_sellerDealerId_idx" ON "WholesaleTrade"("sellerDealerId");

-- CreateIndex
CREATE INDEX "WholesaleTrade_buyerDealerId_idx" ON "WholesaleTrade"("buyerDealerId");

-- CreateIndex
CREATE INDEX "WholesaleTrade_status_idx" ON "WholesaleTrade"("status");

-- CreateIndex
CREATE INDEX "WholesaleTrade_createdAt_idx" ON "WholesaleTrade"("createdAt");

-- AddForeignKey
ALTER TABLE "User" ADD CONSTRAINT "User_dealerId_fkey" FOREIGN KEY ("dealerId") REFERENCES "Dealer"("id") ON DELETE SET NULL ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "IpWhitelist" ADD CONSTRAINT "IpWhitelist_dealerId_fkey" FOREIGN KEY ("dealerId") REFERENCES "Dealer"("id") ON DELETE SET NULL ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Vehicle" ADD CONSTRAINT "Vehicle_dealerId_fkey" FOREIGN KEY ("dealerId") REFERENCES "Dealer"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "VehiclePhoto" ADD CONSTRAINT "VehiclePhoto_vehicleId_fkey" FOREIGN KEY ("vehicleId") REFERENCES "Vehicle"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "WholesaleDisclosure" ADD CONSTRAINT "WholesaleDisclosure_vehicleId_fkey" FOREIGN KEY ("vehicleId") REFERENCES "Vehicle"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "DealerReview" ADD CONSTRAINT "DealerReview_reviewerDealerId_fkey" FOREIGN KEY ("reviewerDealerId") REFERENCES "Dealer"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "DealerReview" ADD CONSTRAINT "DealerReview_reviewedDealerId_fkey" FOREIGN KEY ("reviewedDealerId") REFERENCES "Dealer"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "DealerReview" ADD CONSTRAINT "DealerReview_tradeId_fkey" FOREIGN KEY ("tradeId") REFERENCES "WholesaleTrade"("id") ON DELETE SET NULL ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "WholesaleTrade" ADD CONSTRAINT "WholesaleTrade_vehicleId_fkey" FOREIGN KEY ("vehicleId") REFERENCES "Vehicle"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "WholesaleTrade" ADD CONSTRAINT "WholesaleTrade_sellerDealerId_fkey" FOREIGN KEY ("sellerDealerId") REFERENCES "Dealer"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "WholesaleTrade" ADD CONSTRAINT "WholesaleTrade_buyerDealerId_fkey" FOREIGN KEY ("buyerDealerId") REFERENCES "Dealer"("id") ON DELETE RESTRICT ON UPDATE CASCADE;
