-- CreateEnum
CREATE TYPE "InventoryMode" AS ENUM ('separate', 'shared_pool');

-- CreateEnum
CREATE TYPE "GroupPermissionScope" AS ENUM ('inventory_view', 'inventory_manage', 'stats_view', 'users_view', 'users_manage', 'settings_view', 'settings_manage', 'wholesale_view', 'wholesale_manage');

-- CreateEnum
CREATE TYPE "TransferStatus" AS ENUM ('pending', 'completed', 'cancelled');

-- AlterEnum
ALTER TYPE "UserRole" ADD VALUE 'group_admin';

-- AlterTable
ALTER TABLE "Dealer" ADD COLUMN     "groupId" TEXT;

-- CreateTable
CREATE TABLE "DealerGroup" (
    "id" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "contactEmail" TEXT NOT NULL,
    "contactPhone" TEXT,
    "address" TEXT,
    "isActive" BOOLEAN NOT NULL DEFAULT true,
    "inventoryMode" "InventoryMode" NOT NULL DEFAULT 'separate',
    "verificationStatus" "VerificationStatus" NOT NULL DEFAULT 'unverified',
    "verifiedAt" TIMESTAMP(3),
    "verifiedBy" TEXT,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "DealerGroup_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "DealerGroupUser" (
    "id" TEXT NOT NULL,
    "userId" TEXT NOT NULL,
    "groupId" TEXT NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "DealerGroupUser_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "GroupPermission" (
    "id" TEXT NOT NULL,
    "groupId" TEXT NOT NULL,
    "dealerId" TEXT NOT NULL,
    "scope" "GroupPermissionScope" NOT NULL,
    "granted" BOOLEAN NOT NULL DEFAULT true,
    "configuredBy" TEXT,
    "configuredAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "GroupPermission_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "VehicleTransfer" (
    "id" TEXT NOT NULL,
    "vehicleId" TEXT NOT NULL,
    "fromDealerId" TEXT NOT NULL,
    "toDealerId" TEXT NOT NULL,
    "initiatedBy" TEXT NOT NULL,
    "notes" TEXT,
    "status" "TransferStatus" NOT NULL DEFAULT 'pending',
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "completedAt" TIMESTAMP(3),

    CONSTRAINT "VehicleTransfer_pkey" PRIMARY KEY ("id")
);

-- CreateIndex
CREATE INDEX "DealerGroup_isActive_idx" ON "DealerGroup"("isActive");

-- CreateIndex
CREATE INDEX "DealerGroupUser_userId_idx" ON "DealerGroupUser"("userId");

-- CreateIndex
CREATE INDEX "DealerGroupUser_groupId_idx" ON "DealerGroupUser"("groupId");

-- CreateIndex
CREATE UNIQUE INDEX "DealerGroupUser_userId_groupId_key" ON "DealerGroupUser"("userId", "groupId");

-- CreateIndex
CREATE INDEX "GroupPermission_groupId_idx" ON "GroupPermission"("groupId");

-- CreateIndex
CREATE INDEX "GroupPermission_dealerId_idx" ON "GroupPermission"("dealerId");

-- CreateIndex
CREATE UNIQUE INDEX "GroupPermission_groupId_dealerId_scope_key" ON "GroupPermission"("groupId", "dealerId", "scope");

-- CreateIndex
CREATE INDEX "VehicleTransfer_vehicleId_idx" ON "VehicleTransfer"("vehicleId");

-- CreateIndex
CREATE INDEX "VehicleTransfer_fromDealerId_idx" ON "VehicleTransfer"("fromDealerId");

-- CreateIndex
CREATE INDEX "VehicleTransfer_toDealerId_idx" ON "VehicleTransfer"("toDealerId");

-- CreateIndex
CREATE INDEX "VehicleTransfer_status_idx" ON "VehicleTransfer"("status");

-- CreateIndex
CREATE INDEX "Dealer_groupId_idx" ON "Dealer"("groupId");

-- AddForeignKey
ALTER TABLE "DealerGroupUser" ADD CONSTRAINT "DealerGroupUser_userId_fkey" FOREIGN KEY ("userId") REFERENCES "User"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "DealerGroupUser" ADD CONSTRAINT "DealerGroupUser_groupId_fkey" FOREIGN KEY ("groupId") REFERENCES "DealerGroup"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "GroupPermission" ADD CONSTRAINT "GroupPermission_groupId_fkey" FOREIGN KEY ("groupId") REFERENCES "DealerGroup"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "GroupPermission" ADD CONSTRAINT "GroupPermission_dealerId_fkey" FOREIGN KEY ("dealerId") REFERENCES "Dealer"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "VehicleTransfer" ADD CONSTRAINT "VehicleTransfer_vehicleId_fkey" FOREIGN KEY ("vehicleId") REFERENCES "Vehicle"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "VehicleTransfer" ADD CONSTRAINT "VehicleTransfer_fromDealerId_fkey" FOREIGN KEY ("fromDealerId") REFERENCES "Dealer"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "VehicleTransfer" ADD CONSTRAINT "VehicleTransfer_toDealerId_fkey" FOREIGN KEY ("toDealerId") REFERENCES "Dealer"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Dealer" ADD CONSTRAINT "Dealer_groupId_fkey" FOREIGN KEY ("groupId") REFERENCES "DealerGroup"("id") ON DELETE SET NULL ON UPDATE CASCADE;
