-- CreateEnum
CREATE TYPE "DealerSector" AS ENUM ('vehicles', 'agriculture');

-- AlterTable
ALTER TABLE "Dealer" ADD COLUMN     "sector" "DealerSector" NOT NULL DEFAULT 'vehicles';

-- AlterTable
ALTER TABLE "IpWhitelist" ADD COLUMN     "sector" "DealerSector";

-- CreateTable
CREATE TABLE "Equipment" (
    "id" TEXT NOT NULL,
    "dealerId" TEXT NOT NULL,
    "type" TEXT NOT NULL,
    "brand" TEXT NOT NULL,
    "model" TEXT NOT NULL,
    "year" INTEGER NOT NULL,
    "serialNumber" TEXT,
    "horsepower" INTEGER,
    "engineType" TEXT,
    "hours" INTEGER,
    "ptoType" TEXT,
    "hydraulicFlow" INTEGER,
    "liftCapacity" INTEGER,
    "width" INTEGER,
    "weight" INTEGER,
    "condition" TEXT NOT NULL,
    "lastServiced" TIMESTAMP(3),
    "warrantyExpiry" TIMESTAMP(3),
    "price" INTEGER NOT NULL,
    "wholesalePrice" INTEGER,
    "tradePrice" INTEGER,
    "showRetailPrice" BOOLEAN NOT NULL DEFAULT true,
    "showWholesalePrice" BOOLEAN NOT NULL DEFAULT false,
    "showTradePrice" BOOLEAN NOT NULL DEFAULT false,
    "description" TEXT,
    "features" TEXT,
    "stockNumber" TEXT,
    "sourceUrl" TEXT,
    "status" "VehicleStatus" NOT NULL DEFAULT 'in_stock',
    "soldAt" TIMESTAMP(3),
    "syndicationStatus" "SyndicationStatus" NOT NULL DEFAULT 'none',
    "externalListingId" TEXT,
    "lastSyncedAt" TIMESTAMP(3),
    "wholesaleAvailable" BOOLEAN NOT NULL DEFAULT false,
    "wholesaleListedAt" TIMESTAMP(3),
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "Equipment_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "EquipmentPhoto" (
    "id" TEXT NOT NULL,
    "equipmentId" TEXT NOT NULL,
    "url" TEXT NOT NULL,
    "thumbnailUrl" TEXT,
    "position" INTEGER NOT NULL DEFAULT 0,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "EquipmentPhoto_pkey" PRIMARY KEY ("id")
);

-- CreateIndex
CREATE INDEX "Equipment_dealerId_idx" ON "Equipment"("dealerId");

-- CreateIndex
CREATE INDEX "Equipment_status_idx" ON "Equipment"("status");

-- CreateIndex
CREATE INDEX "Equipment_type_idx" ON "Equipment"("type");

-- CreateIndex
CREATE INDEX "Equipment_brand_idx" ON "Equipment"("brand");

-- CreateIndex
CREATE INDEX "Equipment_wholesaleAvailable_idx" ON "Equipment"("wholesaleAvailable");

-- CreateIndex
CREATE INDEX "EquipmentPhoto_equipmentId_idx" ON "EquipmentPhoto"("equipmentId");

-- CreateIndex
CREATE INDEX "Dealer_sector_idx" ON "Dealer"("sector");

-- CreateIndex
CREATE INDEX "IpWhitelist_sector_idx" ON "IpWhitelist"("sector");

-- AddForeignKey
ALTER TABLE "Equipment" ADD CONSTRAINT "Equipment_dealerId_fkey" FOREIGN KEY ("dealerId") REFERENCES "Dealer"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "EquipmentPhoto" ADD CONSTRAINT "EquipmentPhoto_equipmentId_fkey" FOREIGN KEY ("equipmentId") REFERENCES "Equipment"("id") ON DELETE CASCADE ON UPDATE CASCADE;
